unit Form_GenTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Db, DBTables, Gauges, BDE;

const
     TotalDupRec = 2000;

type
  TFormGenTest = class(TForm)
    StartBtn: TButton;
    TEMPCOMP: TQuery;
    TEMPCOMPCompNo: TIntegerField;
    TEMPCOMPAuNo: TIntegerField;
    TEMPCOMPAuthor: TStringField;
    TEMPCOMPDescription: TStringField;
    TEMPCOMPDetails: TMemoField;
    TEMPCOMPRecordDate: TDateField;
    Gauge1: TGauge;
    Label1: TLabel;
    Label2: TLabel;
    procedure StartBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormGenTest: TFormGenTest;

implementation

uses DataModule_DMCOMP;

{$R *.DFM}

procedure TFormGenTest.StartBtnClick(Sender: TObject);
var
TotalDuplication : Integer;
Counter : Integer;
begin
     Caption := 'Generating test data, please wait ...';
     StartBtn.Enabled := False;
     With DMComp do
     begin
          QComp.Close;
          TEMPCOMP.Close;

          Author.Append;
          AuthorAuthor.Value := 'Fox mulder';
          AuthorEmail.Value := 'fox@xfile.com';
          AuthorWWW.Value := 'www.fox.com';
          Author.Post;

          Author.Append;
          AuthorAuthor.Value := 'Dina Scully';
          AuthorEmail.Value := 'Scully@xfile.com';
          AuthorWWW.Value := 'www.scully.com';
          Author.Post;

          Author.Append;
          AuthorAuthor.Value := 'Jack Chan';
          AuthorEmail.Value := 'jack@niceguy.com';
          AuthorWWW.Value := 'www.jack.com';
          Author.Post;

          Author.Append;
          AuthorAuthor.Value := 'Linda Ho';
          AuthorEmail.Value := 'linda@noplace.com';
          AuthorWWW.Value := 'www.linda.com';
          Author.Post;

          Author.Append;
          AuthorAuthor.Value := 'Steven Jan';
          AuthorEmail.Value := 'steven@noplace.com';
          AuthorWWW.Value := 'www.steven.com';
          Author.Post;

//------------------------------------

          Author.First;

          Comp.Append;
          CompDescription.Value := 'Database Component - TQBuilder';
          CompAuNo.Value := AuthorAuNo.Value;
          CompRecordDate.Value := Now;
          CompWareType.Value := 'Shareware';
          CompPrice.Value := 10;
          Comp.Post;

          Author.Next;

          Comp.Append;
          CompDescription.Value := 'Database Component - TThreadQuery';
          CompAuNo.Value := AuthorAuNo.Value;
          CompRecordDate.Value := Now;
          CompWareType.Value := 'Shareware';
          CompPrice.Value := 20;
          Comp.Post;

          Author.Next;

          Comp.Append;
          CompDescription.Value := 'Database Component - TDBDateDialog';
          CompAuNo.Value := AuthorAuNo.Value;
          CompRecordDate.Value := Now;
          CompWareType.Value := 'Freeware';
          CompPrice.Value := 30;
          Comp.Post;

          Author.Next;

          Comp.Append;
          CompDescription.Value := 'Database Component - TDBEditBtn';
          CompAuNo.Value := AuthorAuNo.Value;
          CompRecordDate.Value := Now;
          CompWareType.Value := 'Freeware';
          CompPrice.Value := 40;
          Comp.Post;

          Author.Next;

          Comp.Append;
          CompDescription.Value := 'Database Component - TDBStatus';
          CompAuNo.Value := AuthorAuNo.Value;
          CompRecordDate.Value := Now;
          CompWareType.Value := 'Freeware';
          CompPrice.Value := 50;
          Comp.Post;

//---------------------------

          DMAssists.FlushChanges;
          
          TEMPCOMP.Open;

          TotalDuplication := TotalDupRec div 5;
          Gauge1.MaxValue := TotalDupRec;
          Gauge1.Progress := 0;

          For Counter := 0 to TotalDuplication do
          begin
               TEMPCOMP.First;
               While not TEMPCOMP.Eof do
               begin
                    Comp.Append;
                    CompDescription.Value := TEMPCOMPDescription.Value + InttoStr(Counter);
                    CompAuNo.Value := TEMPCOMPAuNo.Value;
                    CompRecordDate.Value := Now;
                    If Counter mod 2 = 1 then
                    CompWareType.Value := 'Shareware'
                    else
                    CompWareType.Value := 'Freeware';
                    CompPrice.Value := Counter;
                    Comp.Post;
                    DBiSaveChanges(Comp.Handle);
                    TEMPCOMP.Next;
                    Gauge1.Progress := Gauge1.Progress + 1;
                    Label2.Caption := Inttostr(Gauge1.Progress)+'/'+Inttostr(TotalDupRec);
                    Label2.Update;
               end;
          end;

     end;

     Showmessage('Test Data Generated !');
     Caption := 'Reopening tables, this may take some time, please wait ...';
     TempComp.Close;
     DMComp.DMAssists.BDEDataSetsActive := False;
     DMComp.DMAssists.BDEDataSetsActive := True;
     Close;
end;


end.
